<%@ LANGUAGE="VBScript" %>

<%
'-------------------------------------------------------------------------------
' Microsoft Visual InterDev - Data Form Wizard
' 
' List Page
'
' (c) 1997 Microsoft Corporation.  All Rights Reserved.
'
' This file is an Active Server Page that contains the list view of a Data Form. 
' It requires Microsoft Internet Information Server 3.0 and can be displayed
' using any browser that supports tables. You can edit this file to further 
' customize the list view.
'
'-------------------------------------------------------------------------------

Dim strPagingMove
Dim strDFName
strDFName = "rsxxBaskets"
%>

<SCRIPT RUNAT=Server LANGUAGE="VBScript">

'---- DataTypeEnum Values ----
Const adUnsignedTinyInt = 17
Const adBoolean = 11
Const adLongVarChar = 201
Const adLongVarWChar = 203
Const adBinary = 128
Const adVarBinary = 204
Const adLongVarBinary = 205

'-------------------------------------------------------------------------------
' Purpose:  Substitutes Empty for Null and trims leading/trailing spaces
' Inputs:   varTemp	- the target value
' Returns:	The processed value
'-------------------------------------------------------------------------------

Function ConvertNull(varTemp)
	If IsNull(varTemp) Then
		ConvertNull = ""
	Else
		ConvertNull = Trim(varTemp)
	End If
End Function

'-------------------------------------------------------------------------------
' Purpose:  Embeds bracketing quotes around the string
' Inputs:   varTemp	- the target value
' Returns:	The processed value
'-------------------------------------------------------------------------------

Function QuotedString(varTemp)
	If IsNull(varTemp) Then
		QuotedString = Chr(34) & Chr(34)
	Else
		QuotedString = Chr(34) & CStr(varTemp) & Chr(34)
	End If
End Function

'-------------------------------------------------------------------------------
' Purpose:  Tests string to see if it is a URL by looking for protocol
' Inputs:   varTemp	- the target value
' Returns:	True - if is URL, False if not
'-------------------------------------------------------------------------------

Function IsURL(varTemp)
	IsURL = True
	If UCase(Left(Trim(varTemp), 6)) = "HTTP:/" Then Exit Function
	If UCase(Left(Trim(varTemp), 6)) = "FILE:/" Then Exit Function
	If UCase(Left(Trim(varTemp), 8)) = "MAILTO:/" Then Exit Function
	If UCase(Left(Trim(varTemp), 5)) = "FTP:/" Then Exit Function
	If UCase(Left(Trim(varTemp), 8)) = "GOPHER:/" Then Exit Function
	If UCase(Left(Trim(varTemp), 6)) = "NEWS:/" Then Exit Function
	If UCase(Left(Trim(varTemp), 7)) = "HTTPS:/" Then Exit Function
	If UCase(Left(Trim(varTemp), 8)) = "TELNET:/" Then Exit Function
	If UCase(Left(Trim(varTemp), 6)) = "NNTP:/" Then Exit Function
	IsURL = False
End Function

'-------------------------------------------------------------------------------
' Purpose:  Handles the display of a field from a recordset depending
'			on its data type, attributes, and the current mode.
' Assumes: 	That the recordset containing the field is open
' Inputs:   strFieldName 	- the name of the field in the recordset
'			avarLookup		- array of lookup values
'-------------------------------------------------------------------------------
 
Function ShowField(strFieldName, avarLookup)
	Dim intRow
	Dim strPartial
	Dim strBool
	Dim nPos
	strFieldValue = ""
	nPos=Instr(strFieldName,".")
	Do While nPos > 0 
		strFieldName= Mid (strFieldName, nPos+1)
		nPos=Instr(strFieldName,".")
	Loop 
	If Not IsNull(avarLookup) Then
		Response.Write "<TD BGCOLOR=White NOWRAP><FONT SIZE=-1>" 
		For intRow = 0 to UBound(avarLookup, 2)
			If ConvertNull(avarLookup(0, intRow)) = ConvertNull(rsxxBaskets(strFieldName)) Then
				Response.Write Server.HTMLEncode(ConvertNull(avarLookup(1, intRow)))
				Exit For
			End If
		Next
		Response.Write "</FONT></TD>"
		Exit Function
	End If
	
	Select Case rsxxBaskets(strFieldName).Type
		Case adBoolean, adUnsignedTinyInt				'Boolean
			strBool = ""
			If rsxxBaskets(strFieldName) <> 0 Then
				strBool = "True"
			Else
				strBool = "False"
			End If
			Response.Write "<TD BGCOLOR=White ><FONT SIZE=-1>" & strBool & "</FONT></TD>"
			
		Case adBinary, adVarBinary, adLongVarBinary		'Binary
			Response.Write "<TD BGCOLOR=White ><FONT SIZE=-1>[Binary]</FONT></TD>"
			
		Case adLongVarChar, adLongVarWChar				'Memo
			Response.Write "<TD BGCOLOR=White NOWRAP><FONT SIZE=-1>"
			strPartial = Left(rsxxBaskets(strFieldName), 50)			
			If ConvertNull(strPartial) = "" Then
				Response.Write "&nbsp;"
			Else
				Response.Write Server.HTMLEncode(strPartial)
			End If
			If rsxxBaskets(strFieldName).ActualSize > 50 Then Response.Write "..."
			Response.Write "</FONT></TD>"
			
		Case Else
			Response.Write "<TD BGCOLOR=White ALIGN=Left NOWRAP><FONT SIZE=-1>"
			If ConvertNull(rsxxBaskets(strFieldName)) = "" Then
				Response.Write "&nbsp;"
			Else
				' Check for special field types
				Select Case UCase(Left(rsxxBaskets(strFieldName).Name, 4))
					Case "URL_"
						Response.Write "<A HREF=" & QuotedString(rsxxBaskets(strFieldName)) & ">"
						Response.Write Server.HTMLEncode(ConvertNull(rsxxBaskets(strFieldName)))
						Response.Write "</A>"
					Case Else
						If IsURL(rsxxBaskets(strFieldName)) Then
							Response.Write "<A HREF=" & QuotedString(rsxxBaskets(strFieldName)) & ">"
							Response.Write Server.HTMLEncode(ConvertNull(rsxxBaskets(strFieldName)))
							Response.Write "</A>"
						Else
							Response.Write Server.HTMLEncode(ConvertNull(rsxxBaskets(strFieldName)))
						End If
				End Select
			End If
			Response.Write "</FONT></TD>"
	End Select
End Function

</SCRIPT>

<HTML>
<HEAD>
	<META NAME="GENERATOR" CONTENT="Microsoft Visual InterDev">
	<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=ISO-8859-1">
	<META NAME="Keywords" CONTENT="Microsoft Data Form, xx List">
	<TITLE>xx List</TITLE>
</HEAD>

<!--------------------------- Formatting Section ------------------------------>

<BASEFONT FACE="Arial, Helvetica, sans-serif">
<LINK REL=STYLESHEET HREF="./Stylesheets/Bluerose/Style2.css">
<BODY BACKGROUND="./Images/Bluerose/Background/Back2.jpg" BGCOLOR=White>

<!---------------------------- Lookups Section ------------------------------->

<!---------------------------- Heading Section ------------------------------->

<% Response.Write "<FORM ACTION=xxForm.asp METHOD=""POST"">" %>
<TABLE WIDTH=100% CELLSPACING=0 CELLPADDING=0 BORDER=0>
	<TR>
		<TH NOWRAP BGCOLOR=Silver ALIGN=Left BACKGROUND="./Images/Bluerose/Navigation/Nav1.jpg" >
			<FONT SIZE=6>&nbsp;xx</FONT>
		</TH>
		<TD BGCOLOR=Silver VALIGN=Middle ALIGN=Right WIDTH=100% BACKGROUND="./Images/Bluerose/Navigation/Nav1.jpg">
			<INPUT TYPE="Hidden" NAME="FormMode" VALUE="Edit">
			&nbsp;<INPUT TYPE="SUBMIT" NAME="DataAction" VALUE="Form View">&nbsp;
		</TD>
	</TR>
	<TR>
		<TD BGCOLOR=#FFFFCC COLSPAN=3>
			<FONT SIZE=-1>&nbsp;&nbsp;
			<% 
			If IsEmpty(Session("rsxxBaskets_Filter")) Or Session("rsxxBaskets_Filter")="" Then
				Response.Write "Current Filter: None<BR>"
			Else
				Response.Write "Current Filter: " & Session("rsxxBaskets_FilterDisplay") & "<BR>"
			End If 
			%>
            </FONT>
        </TD>
    </TR></TABLE>
</FORM>

<!----------------------------- List Section --------------------------------->

<TABLE CELLSPACING=0 CELLPADDING=0 BORDER=0 WIDTH=100% >
<TR>
<TD WIDTH=20>&nbsp;</TD>
<TD>
<TABLE CELLSPACING=1 CELLPADDING=1 BORDER=0 WIDTH=100% >
	<TR BGCOLOR=SILVER VALIGN=TOP>
		<TD ALIGN=Center><FONT SIZE=-1>&nbsp;#&nbsp;</FONT></TD>
		<TD ALIGN=Left><FONT SIZE=-1><B>BasketId</B></FONT></TD>
		<TD ALIGN=Left><FONT SIZE=-1><B>CustomerId</B></FONT></TD>
		<TD ALIGN=Left><FONT SIZE=-1><B>CatalogId</B></FONT></TD>
		<TD ALIGN=Left><FONT SIZE=-1><B>NumItems</B></FONT></TD>
	</TR>

<!--METADATA TYPE="DesignerControl" startspan
	<OBJECT ID="rsxxBaskets" WIDTH=151 HEIGHT=24
		CLASSID="CLSID:F602E721-A281-11CF-A5B7-0080C73AAC7E">
		<PARAM NAME="BarAlignment" VALUE="0">
       	<PARAM NAME="PageSize" VALUE="10">
		<PARAM Name="RangeType" Value="2">
		<PARAM Name="DataConnection" Value="eshop">
		<PARAM Name="CommandType" Value="0">
		<PARAM Name="CommandText" Value="SELECT &quot;BasketId&quot;, &quot;CustomerId&quot;, &quot;CatalogId&quot;, &quot;NumItems&quot; FROM dbo.&quot;Baskets&quot;">
		<PARAM Name="CursorType" Value="1">
		<PARAM Name="LockType" Value="3">
		<PARAM Name="CacheRecordset" Value="1">
    </OBJECT>
-->

<%
fHideNavBar = False
fHideNumber = False
fHideRequery = False
fHideRule = False
stQueryString = ""
fEmptyRecordset = False
fFirstPass = True
fNeedRecordset = False
fNoRecordset = False
tBarAlignment = "Left"
tHeaderName = "rsxxBaskets"
tPageSize = 10
tPagingMove = ""
tRangeType = "Table"
tRecordsProcessed = 0
tPrevAbsolutePage = 0
intCurPos = 0
intNewPos = 0
fSupportsBookmarks = True
fMoveAbsolute = False

If Not IsEmpty(Request("rsxxBaskets_PagingMove")) Then
    tPagingMove = Trim(Request("rsxxBaskets_PagingMove"))
End If

If IsEmpty(Session("rsxxBaskets_Recordset")) Then
    fNeedRecordset = True
Else
    If Session("rsxxBaskets_Recordset") Is Nothing Then
        fNeedRecordset = True
    Else
        Set rsxxBaskets = Session("rsxxBaskets_Recordset")
    End If
End If

If fNeedRecordset Then
    Set eshop = Server.CreateObject("ADODB.Connection")
    eshop.ConnectionTimeout = Session("eshop_ConnectionTimeout")
    eshop.CommandTimeout = Session("eshop_CommandTimeout")
    eshop.Open Session("eshop_ConnectionString"), Session("eshop_RuntimeUserName"), Session("eshop_RuntimePassword")
    Set cmdTemp = Server.CreateObject("ADODB.Command")
    Set rsxxBaskets = Server.CreateObject("ADODB.Recordset")
    cmdTemp.CommandText = "SELECT ""BasketId"", ""CustomerId"", ""CatalogId"", ""NumItems"" FROM dbo.""Baskets"""
    cmdTemp.CommandType = 1
    Set cmdTemp.ActiveConnection = eshop
    rsxxBaskets.Open cmdTemp, , 1, 3
End If
On Error Resume Next
If rsxxBaskets.BOF And rsxxBaskets.EOF Then fEmptyRecordset = True
On Error Goto 0
If Err Then fEmptyRecordset = True
If fNeedRecordset Then
    Set Session("rsxxBaskets_Recordset") = rsxxBaskets
End If
rsxxBaskets.PageSize = tPageSize
fSupportsBookmarks = rsxxBaskets.Supports(8192)

If Not IsEmpty(Session("rsxxBaskets_Filter")) And Not fEmptyRecordset Then
    rsxxBaskets.Filter = Session("rsxxBaskets_Filter")
    If rsxxBaskets.BOF And rsxxBaskets.EOF Then fEmptyRecordset = True
End If

If IsEmpty(Session("rsxxBaskets_PageSize")) Then Session("rsxxBaskets_PageSize") = tPageSize
If IsEmpty(Session("rsxxBaskets_AbsolutePage")) Then Session("rsxxBaskets_AbsolutePage") = 1

If Session("rsxxBaskets_PageSize") <> tPageSize Then
    tCurRec = ((Session("rsxxBaskets_AbsolutePage") - 1) * Session("rsxxBaskets_PageSize")) + 1
    tNewPage = Int(tCurRec / tPageSize)
    If tCurRec Mod tPageSize <> 0 Then
        tNewPage = tNewPage + 1
    End If
    If tNewPage = 0 Then tNewPage = 1
    Session("rsxxBaskets_PageSize") = tPageSize
    Session("rsxxBaskets_AbsolutePage") = tNewPage
End If

If fEmptyRecordset Then
    fHideNavBar = True
    fHideRule = True
Else
    tPrevAbsolutePage = Session("rsxxBaskets_AbsolutePage")
    Select Case tPagingMove
        Case ""
            fMoveAbsolute = True
        Case "Requery"
            rsxxBaskets.Requery
            fMoveAbsolute = True
        Case "<<"
            Session("rsxxBaskets_AbsolutePage") = 1
        Case "<"
            If Session("rsxxBaskets_AbsolutePage") > 1 Then
                Session("rsxxBaskets_AbsolutePage") = Session("rsxxBaskets_AbsolutePage") - 1
            End If
        Case ">"
            If Not rsxxBaskets.EOF Then
                Session("rsxxBaskets_AbsolutePage") = Session("rsxxBaskets_AbsolutePage") + 1
            End If
        Case ">>"
            If fSupportsBookmarks Then
                Session("rsxxBaskets_AbsolutePage") = rsxxBaskets.PageCount
            End If
    End Select
    Do
        If fSupportsBookmarks Then
            rsxxBaskets.AbsolutePage = Session("rsxxBaskets_AbsolutePage")
        Else
            If fNeedRecordset Or fMoveAbsolute Or rsxxBaskets.EOF Or Not fSupportsMovePrevious Then
                rsxxBaskets.MoveFirst
                rsxxBaskets.Move (Session("rsxxBaskets_AbsolutePage") - 1) * tPageSize
            Else
                intCurPos = ((tPrevAbsolutePage - 1) * tPageSize) + tPageSize
                intNewPos = ((Session("rsxxBaskets_AbsolutePage") - 1) * tPageSize) + 1
                rsxxBaskets.Move intNewPos - intCurPos
            End If
            If rsxxBaskets.BOF Then rsxxBaskets.MoveNext
        End If
        If Not rsxxBaskets.EOF Then Exit Do
        Session("rsxxBaskets_AbsolutePage") = Session("rsxxBaskets_AbsolutePage") - 1
    Loop
End If

Do
    If fEmptyRecordset Then Exit Do
    If tRecordsProcessed = tPageSize Then Exit Do
    If Not fFirstPass Then
        rsxxBaskets.MoveNext
    Else
        fFirstPass = False
    End If
    If rsxxBaskets.EOF Then Exit Do
    tRecordsProcessed = tRecordsProcessed + 1
%>
<!--METADATA TYPE="DesignerControl" endspan-->

	<TR VALIGN=TOP>
		<TD BGCOLOR=White><FONT SIZE=-1>
		<%
		If tPageSize > 0 Then
			tCurRec = ((Session("rsxxBaskets_AbsolutePage") - 1) * tPageSize) + tRecordsProcessed
		Else
			tRecordsProcessed = tRecordsProcessed + 1
			tCurRec = tRecordsProcessed
		End If
		Response.Write "<A HREF=" & QuotedString("xxAction.asp?Bookmark=" & tCurRec & "&DataAction=Find") & ">" & tCurRec & "</A>"
		%>

		</FONT></TD>
		<%
		ShowField "BasketId", Null
		ShowField "CustomerId", Null
		ShowField "CatalogId", Null
		ShowField "NumItems", Null
		fHideRule = True
		%>
	</TR>

<!--METADATA TYPE="DesignerControl" startspan
    <OBJECT ID="DataRangeFtr1" WIDTH=151 HEIGHT=24
        CLASSID="CLSID:F602E722-A281-11CF-A5B7-0080C73AAC7E">
    </OBJECT>
-->
<%
Loop
If tRangeType = "Table" Then Response.Write "</TABLE>"
If tPageSize > 0 Then
    If Not fHideRule Then Response.Write "<HR>"
    If Not fHideNavBar Then
        %>
        <TABLE WIDTH=100% >
        <TR>
            <TD WIDTH=100% >
                <P ALIGN=<%= tBarAlignment %> >
                <FORM <%= "ACTION=""" & Request.ServerVariables("PATH_INFO") & stQueryString & """" %> METHOD="POST">
                    <INPUT TYPE="Submit" NAME="<%= tHeaderName & "_PagingMove" %>" VALUE="   &lt;&lt;   ">
                    <INPUT TYPE="Submit" NAME="<%= tHeaderName & "_PagingMove" %>" VALUE="   &lt;    ">
                    <INPUT TYPE="Submit" NAME="<%= tHeaderName & "_PagingMove" %>" VALUE="    &gt;   ">
                    <% If fSupportsBookmarks Then %>
                        <INPUT TYPE="Submit" NAME="<%= tHeaderName & "_PagingMove" %>" VALUE="   &gt;&gt;   ">
                    <% End If %>
                    <% If Not fHideRequery Then %>
                        <INPUT TYPE="Submit" NAME="<% =tHeaderName & "_PagingMove" %>" VALUE=" Requery ">
                    <% End If %>
                </FORM>
                </P>
            </TD>
            <TD VALIGN=MIDDLE ALIGN=RIGHT>
                <FONT SIZE=2>
                <%
                If Not fHideNumber Then
                    If tPageSize > 1 Then
                        Response.Write "<NOBR>Page: " & Session(tHeaderName & "_AbsolutePage") & "</NOBR>"
                    Else
                        Response.Write "<NOBR>Record: " & Session(tHeaderName & "_AbsolutePage") & "</NOBR>"
                    End If
                End If
                %>
                </FONT>
            </TD>
        </TR>
        </TABLE>
    <%
    End If
End If
%>
<!--METADATA TYPE="DesignerControl" endspan-->

<!---------------------------- Footer Section -------------------------------->

<% 
' TEMP: cache here until CacheRecordset property is implemented in
' 		data range
If fNeedRecordset Then
	Set Session("rsxxBaskets_Recordset") = rsxxBaskets
End If 
%>

</TD></TR></TABLE>
</BODY>
</HTML>

